// controllers/authController.js
const User = require('../models/User');
const bcrypt = require('bcrypt');

const saltRounds = 10;

const authController = {
  // Tampilkan halaman registrasi
  showRegister: (req, res) => {
    res.render('pages/register', { title: 'Register', error: null });
  },

  // Proses registrasi
  register: (req, res) => {
    const { username, email, password } = req.body;
    if (!username || !email || !password) {
      return res.render('pages/register', { title: 'Register', error: 'Semua field wajib diisi!' });
    }
    // Cek apakah user sudah ada
    User.findByEmail(email, (err, results) => {
      if (err) {
        console.error(err);
        return res.render('pages/register', { title: 'Register', error: 'Terjadi kesalahan, coba lagi!' });
      }
      if (results.length > 0) {
        return res.render('pages/register', { title: 'Register', error: 'Email sudah terdaftar!' });
      }
      // Hash password secara asinkron
      bcrypt.hash(password, saltRounds, (hashErr, hashedPassword) => {
        if (hashErr) {
          console.error(hashErr);
          return res.render('pages/register', { title: 'Register', error: 'Gagal mendaftar, coba lagi.' });
        }
        // Buat user baru dengan password yang telah di-hash
        User.create({ username, email, password: hashedPassword }, (createErr, result) => {
          if (createErr) {
            console.error(createErr);
            return res.render('pages/register', { title: 'Register', error: 'Gagal mendaftar, coba lagi.' });
          }
          res.redirect('/login');
        });
      });
    });
  },

  // Tampilkan halaman login
  showLogin: (req, res) => {
    res.render('pages/login', { title: 'Login', error: null });
  },

  // Proses login
  login: (req, res) => {
    const { email, password } = req.body;
    if (!email || !password) {
      return res.render('pages/login', { title: 'Login', error: 'Email dan password wajib diisi!' });
    }
    User.findByEmail(email, (err, results) => {
      if (err || results.length === 0) {
        return res.render('pages/login', { title: 'Login', error: 'Email atau password salah!' });
      }
      const user = results[0];
      // Bandingkan password yang diinput dengan password yang di-hash di database secara asinkron
      bcrypt.compare(password, user.password, (compareErr, isMatch) => {
        if (compareErr || !isMatch) {
          return res.render('pages/login', { title: 'Login', error: 'Email atau password salah!' });
        }
        req.session.user = { id: user.id, username: user.username, email: user.email };
        res.redirect('/');
      });
    });
  },

  // Proses logout
  logout: (req, res) => {
    req.session.destroy((err) => {
      if (err) {
        console.error(err);
      }
      res.redirect('/login');
    });
  }
};

module.exports = authController;
