const Latihan = require('../models/Latihan');

const latihanController = {
  index: (req, res) => {
    // Ambil semua latihan (atau latihan berdasarkan materi, jika diperlukan)
    Latihan.getAllByMateri(null, (err, results) => {
      if (err) {
        console.error(err);
        return res.render('pages/latihan', { title: 'Latihan Soal', error: 'Terjadi kesalahan, silakan coba lagi.', latihan: [] });
      }
      res.render('pages/latihan', { title: 'Latihan Soal', error: null, latihan: results });
    });
  },

  detail: (req, res) => {
    const latihanId = req.params.id;
    Latihan.getById(latihanId, (err, results) => {
      if (err || results.length === 0) {
        return res.render('pages/latihanDetail', { title: 'Detail Latihan', error: 'Latihan tidak ditemukan', latihan: null });
      }
      res.render('pages/latihanDetail', { title: 'Detail Latihan', error: null, latihan: results[0] });
    });
  },

  submit: (req, res) => {
    const latihanId = req.params.id;
    const jawaban = req.body.jawaban;
    // Logika untuk memproses jawaban:
    // Misalnya, bandingkan jawaban dengan solusi, simpan hasil ke database, dsb.
    // Untuk contoh sederhana, kita hanya akan mencetak jawaban dan mengalihkan kembali ke detail latihan.
    console.log("Jawaban yang diterima untuk latihan " + latihanId + ": " + jawaban);
    // Lakukan proses penyimpanan atau evaluasi jawaban di sini...
    // Setelah itu, redirect ke halaman detail latihan
    res.redirect('/latihan/' + latihanId);
  }
};

module.exports = latihanController;
